@extends('layouts.app')
@section('content')
<div class="content-wrapper">
	<div class="content pt-3">
		<div class="container-fluid">
			<div class="row">
				<div class="col-12">
					<div class="card border-0 shadow-custom">
						<div class="card-header border-grey">
							<h3 class="card-title">
								{{ __('expense.list_title') }}
							</h3>
						</div>
						<div class="card-body px-3 pt-3 pb-0">
							<div class="row">
								<div class="col-md-12 d-flex justify-content-end ">
									<form method="post" action="{{ route('expense.index') }}">
										{{ csrf_field() }}
										<div class="input-group mb-3">
											<input type="text" name="search" class="form-control"
												placeholder="{{ __('expense.ph_search') }}" required>
											<div class="input-group-append">
												<button class="btn btn-primary" type="submit"><i
														class="fas fa-search"></i></button>
											</div>
										</div>
									</form>
								</div>
								<div class="col-12">
									<div class="table-responsive">
										<table class="table custom-table-bordered table-hover">
											<thead>
												<tr>
													<th>{{ __('expense.th_name') }}</th>
													<th class="nowrap">{{ __('expense.th_amount') }}</th>
													<th class="nowrap">{{ __('expense.th_date') }}</th>
													<th class="nowrap">{{ __('expense.description') }}</th>
													<th class="fixed-width-td">{{ __('expense.th_action') }}</th>
												</tr>
											</thead>
											<tbody>
												@foreach($expenses as $expense)
												<tr>
													<td class="align-middle">{{ $expense->name }}</td>
													<td class="align-middle nowrap">{{
														format_amount($expense->transaction->amount) }}</td>
													<td class="align-middle nowrap">{{
														format_date($expense->transaction->date) }}</td>
													<td class="align-middle nowrap">{{ $expense->transaction->note }}
													</td>
													<td>
														<div class="d-flex">
															<a href="{{ route('expense.edit', $expense->id) }}"
																type="button" class="btn btn-warning mr-2"><i
																	class="fa fa-edit"></i></a>
															<form class="d-inline js-confirm-delete" method="POST"
																action="{{ route('expense.destroy', $expense->id) }}">
																{{ csrf_field() }}
																@method('DELETE')
																<button class="btn btn-primary"><i
																		class="fa fa-trash"></i></button>
															</form>
														</div>
													</td>
												</tr>
												@endforeach

												@if(count($expenses) == 0)
												<tr>
													<td colspan="11">
														<p class="text-center mb-0">{{ __('expense.no_record_found') }}
														</p>
													</td>
												</tr>
												@endif
											</tbody>
										</table>
									</div>
								</div>
								<div class="col-12">
									<div class="d-flex justify-content-end">
										@if($paginate)
										{{ $expenses->links() }}
										@endif
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection